<?php
session_start();
include 'config.php';
$query = $conn->query("SELECT * FROM pengurus ORDER BY id_kepengurusan DESC LIMIT 1");
$pengurus = $query->fetch_assoc();

// Query ambil 5 artikel terbaru + kategori
$sql = "SELECT a.*, k.nama_kategori 
        FROM artikel a 
        LEFT JOIN kategori k ON a.kategori_id = k.id_kategori 
        ORDER BY a.created_at DESC 
        LIMIT 5";

$result = mysqli_query($conn, $sql);

// Cek jika query gagal
if (!$result) {
    die('Query error: ' . mysqli_error($conn));
}

// Cek apakah ada data
if (mysqli_num_rows($result) > 0) {
    $featured = mysqli_fetch_assoc($result); // Artikel pertama sebagai featured
    $articles = [];

    while ($row = mysqli_fetch_assoc($result)) {
        $articles[] = $row; // Simpan sisa artikel ke array
    }
} else {
    $featured = null;
    $articles = [];
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>PMII Blitar</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/favicon.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">
  
    <style>
    .pengurus-card {
      transition: transform 0.3s ease;
      margin-bottom: 20px;      /* rapatkan antar baris */
      padding: 0 5px;           /* sempitkan spasi horizontal */
    }
    .pengurus-card:hover {
      transform: translateY(-5px);
    }
    .pengurus-img-wrapper {
      position: relative;
      width: 225px;             /* sedikit diperlebar */
      height: 225px;            /* sedikit dipertinggi */
      margin: 0 auto 8px;       /* rapatkan jarak ke teks */
    }
    .pengurus-img-wrapper::before {
      content: "";
      background-image: url('assets/img/favicon.png'); /* logo watermark */
      background-size: 95%;        /* hampir penuh wrapper */
      background-position: center;
      background-repeat: no-repeat;
      position: absolute;
      top: 50%;                    /* pusat vertikal */
      left: 50%;                   /* pusat horizontal */
      width: 95%;                  /* hampir penuh wrapper */
      height: 95%;
      border-radius: 50%;
      transform: translate(-50%, -50%);
      z-index: 1;
      opacity: 0.7;               /* tingkat kejelasan lebih tinggi */
    }
    .pengurus-img {
      position: relative;
      z-index: 2;
      width: 100%;
      height: 100%;
      object-fit: contain;
      border-radius: 50%;
    }
    .title-limit {
      display: -webkit-box;
      -webkit-line-clamp: 3;       /* Batasi 3 baris */
      -webkit-box-orient: vertical;
      overflow: hidden;
      text-overflow: ellipsis;
      height: 4.5em;               /* Estimasi tinggi 3 baris */
      line-height: 1.5em;
      font-weight: 450;
      margin: 0;
    }
    .article-card {
      background: #ffffff, transparent 30%;
      border-radius: 15px;
      overflow: hidden;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      cursor: pointer;
    }
    
    .article-card:hover {
      transform: scale(1.05); /* zoom sedikit */
      box-shadow: 0 8px 20px rgba(0,0,0,0.25); /* shadow lebih besar */
    }
    </style>
</head>
<body class="index-page">
  <header id="header" class="header d-flex align-items-center fixed-top">
    <div class="container-fluid container-xl position-relative d-flex align-items-center justify-content-between">
      <a href="index.php" class="logo d-flex align-items-center">
        <!-- Uncomment the line below if you also wish to use an image logo -->
         <img src="assets/img/favicon.png" alt=""> 
        <h1 class="sitename">PMII Blitar</h1>
      </a>
      <nav id="navmenu" class="navmenu">
        <ul>
          <li><a href="#hero" class="active">Home</a></li>
          <li><a href="#profil">Profile</a></li>
          <li><a href="#organization">Organization</a></li>
          <li><a href="#gallery">Gallery</a></li>
          <li><a href="#pengurus">Pengurus</a></li>
          <li><a href="#faq">Faq</a></li>
          <li><a href="#footer">Contact</a></li> 
          <a class="btn-get" href="login">Member Area</a>
        </ul>
        <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
        
      </nav>
    </div>
  </header>

  <main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section dark-background">
      <img src="assets/img/bg_header.webp" alt="" class="hero-bg">

      <div class="container">
        <div class="row gy-4 justify-content-between">
          <div class="col-lg-4 order-lg-last hero-img" data-aos="zoom-out" data-aos-delay="100">
            <img src="assets/img/logo.png" class="img-fluid animated" alt="">
          </div>

          <div class="col-lg-6  d-flex flex-column justify-content-center" data-aos="fade-in">
            <h1>Pergerakan Mahasiswa Islam Indonesia<span> Blitar</span></h1>
            <p>Dzikir, Fikir, dan Amal Shaleh</p>
            <!--<div class="d-flex">-->
            <!--  <a href="#about" class="btn-get-started">Get Started</a>-->
            <!--  <a href="https://www.youtube.com/watch?v=Y7f98aduVJ8" class="glightbox btn-watch-video d-flex align-items-center"><i class="bi bi-play-circle"></i><span>Watch Video</span></a>-->
            <!--</div>-->
          </div>

        </div>
      </div>

      <svg class="hero-waves" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 24 150 28 " preserveAspectRatio="none">
        <defs>
          <path id="wave-path" d="M-160 44c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352z"></path>
        </defs>
        <g class="wave1">
          <use xlink:href="#wave-path" x="50" y="3"></use>
        </g>
        <g class="wave2">
          <use xlink:href="#wave-path" x="50" y="0"></use>
        </g>
        <g class="wave3">
          <use xlink:href="#wave-path" x="50" y="9"></use>
        </g>
      </svg>

    </section><!-- /Hero Section -->

    <!-- About Section -->
    <section id="profil" class="about section">

      <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row align-items-xl-center gy-5">

          <div class="col-xl-5 content">
            <h3>Profil</h3>
            <h2>Profil PMII Blitar</h2>
            <p><i>Pergerakan Mahasiswa Islam Indonesia (PMII) Blitar adalah organisasi kemahasiswaan yang berlandaskan nilai-nilai Islam Ahlussunnah wal Jama'ah serta berpijak pada semangat kebangsaan. Kami hadir sebagai wadah kaderisasi dan pembinaan mahasiswa untuk melahirkan generasi muda yang kritis, progresif, dan berintegritas.</i>
            <br><br>PMII Blitar fokus pada pengembangan sumber daya manusia melalui pendidikan, kaderisasi, serta penguatan nilai-nilai keislaman dan kebangsaan. Berbasis pada prinsip independensi, profesionalisme, dan kolektivitas, PMII Blitar berkomitmen menciptakan ruang yang inklusif dan dinamis bagi mahasiswa.
<br><br>Melalui berbagai program kaderisasi, advokasi, dan pemberdayaan masyarakat, PMII Blitar terus mendorong terwujudnya masyarakat adil dan makmur yang diridai Allah SWT, sebagaimana cita-cita besar PMII sejak kelahirannya.</p>
            <a href="#features" class="read-more"><span>Baca Selengkapnya</span><i class="bi bi-arrow-right"></i></a>
          </div>

          <div class="col-xl-7">
              <div class="row gy-4 icon-boxes">
            
                <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="icon-box">
                    <i class="bi bi-person-badge-fill"></i>
                    <h3>Kaderisasi Berjenjang</h3>
                    <p>Proses pembinaan berkelanjutan melalui MAPABA, PKD, dan PKL untuk mencetak kader yang berintegritas dan berwawasan kebangsaan.</p>
                  </div>
                </div><!-- End Icon Box -->
                
                <div class="col-md-6" data-aos="fade-up" data-aos-delay="300">
                  <div class="icon-box">
                    <i class="bi bi-megaphone-fill"></i>
                    <h3>Advokasi & Gerakan Sosial</h3>
                    <p>PMII hadir dalam isu-isu kerakyatan dan kebijakan publik melalui aksi nyata, advokasi, dan suara kritis di ruang publik.</p>
                  </div>
                </div><!-- End Icon Box -->
                
                <div class="col-md-6" data-aos="fade-up" data-aos-delay="400">
                  <div class="icon-box">
                    <i class="bi bi-book-fill"></i>
                    <h3>Pendidikan Islam & Aswaja</h3>
                    <p>Penanaman nilai-nilai Islam Ahlussunnah wal Jama'ah sebagai dasar gerakan dan identitas kader PMII dalam kehidupan kampus dan masyarakat.</p>
                  </div>
                </div><!-- End Icon Box -->
                
                <div class="col-md-6" data-aos="fade-up" data-aos-delay="500">
                  <div class="icon-box">
                    <i class="bi bi-globe-americas"></i>
                    <h3>Pengabdian Masyarakat</h3>
                    <p>Wujud nyata kontribusi PMII dalam pembangunan sosial melalui kegiatan seperti bakti sosial, literasi, dan pendampingan masyarakat.</p>
                  </div>
                </div><!-- End Icon Box -->

            
              </div>
            </div>


        </div>
      </div>

    </section><!-- /About Section -->

    <section id="features" class="features section">
      <div class="container">
        <div class="row gy-4">
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="100">
            <div class="features-item">
              <i class="bi bi-people-fill" style="color: #007bff;"></i>
              <h3><a href="#" class="stretched-link">Kaderisasi</a></h3>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="200">
            <div class="features-item">
              <i class="bi bi-book-half" style="color: #28a745;"></i>
              <h3><a href="#" class="stretched-link">Kajian Aswaja</a></h3>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="300">
            <div class="features-item">
              <i class="bi bi-megaphone" style="color: #ffc107;"></i>
              <h3><a href="#" class="stretched-link">Advokasi Sosial</a></h3>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="400">
            <div class="features-item">
              <i class="bi bi-lightbulb-fill" style="color: #6610f2;"></i>
              <h3><a href="#" class="stretched-link">Intelektual Progresif</a></h3>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="500">
            <div class="features-item">
              <i class="bi bi-flag-fill" style="color: #dc3545;"></i>
              <h3><a href="#" class="stretched-link">Cinta Tanah Air</a></h3>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="600">
            <div class="features-item">
              <i class="bi bi-gender-female" style="color: #e83e8c;"></i>
              <h3><a href="#" class="stretched-link">KOPRI</a></h3>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="700">
            <div class="features-item">
              <i class="bi bi-heart-fill" style="color: #fd7e14;"></i>
              <h3><a href="#" class="stretched-link">Pengabdian Umat</a></h3>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="800">
            <div class="features-item">
              <i class="bi bi-chat-left-text" style="color: #17a2b8;"></i>
              <h3><a href="#" class="stretched-link">Diskusi Publik</a></h3>
            </div>
          </div>
    
        </div>
      </div>
    </section>

    <section id="stats" class="stats section light-background">
      <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row gy-4">
    
          <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
            <i class="bi bi-people-fill"></i>
            <div class="stats-item">
              <span data-purecounter-start="0" data-purecounter-end="1500" data-purecounter-duration="1" class="purecounter"></span>
              <p>Anggota Aktif</p>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
            <i class="bi bi-award-fill"></i>
            <div class="stats-item">
              <span data-purecounter-start="0" data-purecounter-end="320" data-purecounter-duration="1" class="purecounter"></span>
              <p>Alumni Kaderisasi</p>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
            <i class="bi bi-calendar-event-fill"></i>
            <div class="stats-item">
              <span data-purecounter-start="0" data-purecounter-end="45" data-purecounter-duration="1" class="purecounter"></span>
              <p>Kegiatan Tahunan</p>
            </div>
          </div>
    
          <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
            <i class="bi bi-journal-text"></i>
            <div class="stats-item">
              <span data-purecounter-start="0" data-purecounter-end="25" data-purecounter-duration="1" class="purecounter"></span>
              <p>Publikasi & Kajian</p>
            </div>
          </div>
    
        </div>
      </div>
    </section>
    <!-- Gallery Section -->
<section id="gallery" class="gallery section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2>Gallery</h2>
    <div><span>Galeri & Kegiatan</span> <span class="description-title"></span></div>
  </div><!-- End Section Title -->

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row no-gutters" id="galleryContainer">
      <?php
      include 'config.php';
      $sql = "SELECT * FROM gambar ORDER BY id DESC";
      $result = mysqli_query($conn, $sql);
      $gambar = [];

      if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
          $gambar[] = htmlspecialchars($row['url_gambar']);
        }
      }

      foreach ($gambar as $index => $url) {
        echo '
        <div class="col-lg-3 col-md-4 col-6 p-1 gallery-item-wrapper" data-index="' . $index . '">
          <div class="gallery-item">
            <a href="' . $url . '" class="glightbox" data-gallery="images-gallery">
              <img src="' . $url . '" alt="Gambar Galeri" class="img-gallery">
            </a>
          </div>
        </div>';
      }
      ?>
    </div>

    <!-- Tombol dan Pagination -->
    <div class="text-center mt-4">
      <button class="btn-lihat-semua" id="showAllBtn">Lihat Semua</button>
      <div id="pagination" class="mt-3" style="display: none;"></div>
    </div>
  </div>
</section>

<!-- CSS Tambahan -->
<style>
  .img-gallery {
    width: 100%;
    height: 160px;
    object-fit: cover;
    border-radius: 10px;
    display: block;
    transition: transform 0.2s ease;
  }

  .img-gallery:hover {
    transform: scale(1.02);
  }

  .p-1 {
    padding: 2px !important;
  }

  .btn-lihat-semua {
    background-color: #ffffff;
    color: #0b72d7;
    border: none;
    padding: 10px 22px;
    border-radius: 20px;
    font-weight: bold;
    cursor: pointer;
    transition: background 0.3s ease;
  }

  .btn-lihat-semua:hover {
    background-color: #e0e0e0;
  }

  .pagination-btn {
    background-color: #0b72d7;
    color: white;
    border: none;
    padding: 8px 14px;
    margin: 0 2px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 0.9rem;
  }

  .pagination-btn.active {
    background-color: #ffffff;
    color: #0b72d7;
    font-weight: bold;
  }
</style>

<!-- JavaScript Pagination -->
<script>
  const itemsPerPage = 8;
  const allItems = document.querySelectorAll('.gallery-item-wrapper');
  const showAllBtn = document.getElementById('showAllBtn');
  const pagination = document.getElementById('pagination');

  function showPage(pageNum) {
    const start = (pageNum - 1) * itemsPerPage;
    const end = start + itemsPerPage;

    allItems.forEach((item, index) => {
      item.style.display = index >= start && index < end ? 'block' : 'none';
    });

    const totalPages = Math.ceil(allItems.length / itemsPerPage);
    pagination.innerHTML = '';
    for (let i = 1; i <= totalPages; i++) {
      const btn = document.createElement('button');
      btn.textContent = i;
      btn.classList.add('pagination-btn');
      if (i === pageNum) btn.classList.add('active');
      btn.addEventListener('click', () => showPage(i));
      pagination.appendChild(btn);
    }
  }

  // Awalnya tampil hanya 6 item pertama
  window.addEventListener('DOMContentLoaded', () => {
    allItems.forEach((item, index) => {
      item.style.display = index < itemsPerPage ? 'block' : 'none';
    });
  });

  showAllBtn.addEventListener('click', () => {
    showPage(1);
    pagination.style.display = 'block';
    showAllBtn.style.display = 'none';
  });
</script>


        </div>

      </div>

    </section><!-- /Gallery Section -->

<section id="artikel" class="faq section">
  <div class="container section-title" data-aos="fade-up">
    <h2>Artikel</h2>
    <div><span>Update Artikel Terkini</span> <span class="description-title"></span></div>
  </div><!-- End Section Title -->

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row">
      <?php
      // Ambil 6 artikel terbaru
      $query = mysqli_query($conn, "
          SELECT a.*, k.nama_kategori 
          FROM artikel a 
          LEFT JOIN kategori k ON a.kategori_id = k.id_kategori
          ORDER BY a.created_at DESC 
          LIMIT 6
        ");
     
      while ($row = mysqli_fetch_assoc($query)): ?>
        <div class="col-md-3 mb-4">
          <div class="article-card">
            <a href="post/<?= urlencode($row['slug']) ?>" title="<?= htmlspecialchars($row['title']) ?>">
              <img src="uploads/<?= htmlspecialchars($row['image']) ?>" 
                   alt="<?= htmlspecialchars($row['title']) ?>" 
                   style="width: 100%; height: 220px; object-fit: cover; border-radius: 15px 15px 0 0;">
              <div style="padding: 10px;">
                <h5 class="title-limit"><?= htmlspecialchars($row['title']) ?></h5>
                <small style="color: gray;">
                  <?php if (!empty($row['nama_kategori'])): ?>
                    <i class="bi bi-folder-fill me-1"></i> <?= htmlspecialchars($row['nama_kategori']) ?> &nbsp;&bull;&nbsp;
                  <?php endif; ?>
                  <i class="bi bi-calendar-event me-1"></i> <?= date('d M Y', strtotime($row['created_at'])) ?>
                </small>
              </div>
            </a>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
  </div>
</section>

    <!-- Details Section -->
    <section id="organization" class="details section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <h2>Lebih Lengkap Tentang Kami</h2>
        <div><span>Landasan Hukum, Fungsi, Program & Kapasitas</span> <span class="description-title"></span></div>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-4 align-items-center features-item">
          <div class="col-md-5 d-flex align-items-center" data-aos="zoom-out" data-aos-delay="100">
            <img src="assets/img/landasan_hukum.png" class="img-fluid" alt="">
          </div>
          <div class="col-md-7" data-aos="fade-up" data-aos-delay="100">
            <h3>Landasan Hukum</h3>
            <p class="fst-italic">
              PMII berdiri pada tanggal 17 April 1960 di Surabaya, dan berlandaskan:
            </p>
            <ul>
              <li><i class="bi bi-check"></i><span>Pancasila sebagai dasar negara.</span></li>
              <li><i class="bi bi-check"></i> <span>UUD 1945 sebagai konstitusi negara.</span></li>
              <li><i class="bi bi-check"></i> <span>Ahlussunnah wal Jama’ah sebagai asas keagamaan.</span></li>
              <li><i class="bi bi-check"></i> <span>AD/ART PMII sebagai pedoman organisasi.</span></li>
            </ul>
          </div>
        </div><!-- Features Item -->

        <div class="row gy-4 align-items-center features-item">
          <div class="col-md-5 order-1 order-md-2 d-flex align-items-center" data-aos="zoom-out" data-aos-delay="200">
            <img src="assets/img/favicon_big.png" class="img-fluid" alt="">
          </div>
          <div class="col-md-7 order-2 order-md-1" data-aos="fade-up" data-aos-delay="200">
            <h3>Fungsi Organisasi PMII</h3>
             <p class="fst-italic">
              PMII berfungsi sebagai:
            </p>
            <ul>
              <li><i class="bi bi-check"></i><span> Wadah pembinaan dan pengembangan kader mahasiswa yang Islami, intelektual, dan progresif.</span></li>
              <li><i class="bi bi-check"></i> <span> Ruang perjuangan mahasiswa dalam membela kepentingan rakyat dan nilai-nilai keadilan sosial.</span></li>
              <li><i class="bi bi-check"></i> <span> Mediator dalam menciptakan mahasiswa yang memiliki kapasitas spiritual, intelektual, dan sosial.</span></li>
            </ul>
          </div>
        </div><!-- Features Item -->

        <div class="row gy-4 align-items-center features-item">
          <div class="col-md-5 d-flex align-items-center" data-aos="zoom-out">
            <img src="assets/img/character_pmii.png" class="img-fluid" alt="">
          </div>
          <div class="col-md-7" data-aos="fade-up">
            <h3>Program Kerja PMII</h3>
            <p> Program kerja PMII mencakup aspek ideologi, kaderisasi, advokasi, dan sosial keumatan, di antaranya:</p>
            <ul>
              <li><i class="bi bi-check"></i> <span>Kaderisasi Formal: MAPABA, PKD, PKL, dan PKN.</span></li>
              <li><i class="bi bi-check"></i><span>Diskusi dan Kajian Strategis: Kajian isu nasional dan keislaman.</span></li>
              <li><i class="bi bi-check"></i> <span>Penguatan Kapasitas Kader: Pelatihan jurnalistik, riset sosial, dan manajemen organisasi.</span></li>
              <li><i class="bi bi-check"></i> <span>Gerakan Sosial dan Advokasi: Aksi solidaritas, bantuan masyarakat, serta advokasi kebijakan.</span></li>
              <li><i class="bi bi-check"></i> <span>Pemberdayaan Ekonomi: Unit usaha kader dan koperasi mahasiswa.</span></li>
            </ul>
          </div>
        </div><!-- Features Item -->

        <div class="row gy-4 align-items-center features-item">
          <div class="col-md-5 order-1 order-md-2 d-flex align-items-center" data-aos="zoom-out">
            <img src="assets/img/capacity.png" class="img-fluid" alt="">
          </div>
          <div class="col-md-7 order-2 order-md-1" data-aos="fade-up">
            <h3>Kapasitas Organisasi</h3>
            <p class="fst-italic">
            PMII memiliki struktur nasional dari tingkat pusat hingga komisariat:            
            </p>
            <ul>
              <li><i class="bi bi-check"></i> <span>Pengurus Besar (PB) di tingkat nasional.</span></li>
              <li><i class="bi bi-check"></i><span>Pengurus Koordinator Cabang (PKC) di tingkat provinsi.</span></li>
              <li><i class="bi bi-check"></i> <span>Pengurus Cabang (PC) di kabupaten/kota.</span></li>
              <li><i class="bi bi-check"></i> <span>Pengurus Komisariat (PK) di kampus/universitas.</span></li>
              <li><i class="bi bi-check"></i> <span>Pengurus Rayon (PR) di tingkat fakultas atau jurusan.</span></li>
            </ul>
          </div>
        </div><!-- Features Item -->

      </div>

    </section><!-- /Details Section -->
    
<!-- Pengurus Section -->
<section id="pengurus" class="team section">
  <div class="container section-title" data-aos="fade-up">
    <h2>Pengurus</h2>
    <div><span><?= htmlspecialchars($pengurus['pengurus_periode']) ?></span></div>
  </div>

  <div class="container">
    <div class="row gy-2 gx-2 justify-content-center"> <!-- gy-2 & gx-2 untuk jarak lebih rapat -->

      <!-- Ketua -->
      <div class="col-lg-3 col-md-4 col-sm-6 text-center pengurus-card" data-aos="fade-up">
        <div class="pengurus-img-wrapper mb-2"> <!-- mb-2 supaya teks lebih rapat -->
          <img src="<?= htmlspecialchars($pengurus['foto_ketua']) ?>" alt="Ketua" class="pengurus-img">
        </div>
        <h5 class="fw-bold mb-1"><?= htmlspecialchars($pengurus['ketua']) ?></h5>
        <p class="text-muted">Ketua Umum</p>
      </div>

      <!-- Sekretaris -->
      <div class="col-lg-3 col-md-4 col-sm-6 text-center pengurus-card" data-aos="fade-up" data-aos-delay="100">
        <div class="pengurus-img-wrapper mb-2">
          <img src="<?= htmlspecialchars($pengurus['foto_sekretaris']) ?>" alt="Sekretaris" class="pengurus-img">
        </div>
        <h5 class="fw-bold mb-1"><?= htmlspecialchars($pengurus['sekretaris']) ?></h5>
        <p class="text-muted">Sekretaris</p>
      </div>

      <!-- Bendahara -->
      <div class="col-lg-3 col-md-4 col-sm-6 text-center pengurus-card" data-aos="fade-up" data-aos-delay="200">
        <div class="pengurus-img-wrapper mb-2">
          <img src="<?= htmlspecialchars($pengurus['foto_bendahara']) ?>" alt="Bendahara" class="pengurus-img">
        </div>
        <h5 class="fw-bold mb-1"><?= htmlspecialchars($pengurus['bendahara']) ?></h5>
        <p class="text-muted">Bendahara</p>
      </div>

      <!-- Kopri -->
      <?php if (!empty($pengurus['kopri'])): ?>
      <div class="col-lg-3 col-md-4 col-sm-6 text-center pengurus-card" data-aos="fade-up" data-aos-delay="300">
        <div class="pengurus-img-wrapper mb-2">
          <img src="<?= htmlspecialchars($pengurus['foto_kopri']) ?>" alt="Kopri" class="pengurus-img">
        </div>
        <h5 class="fw-bold mb-1"><?= htmlspecialchars($pengurus['kopri']) ?></h5>
        <p class="text-muted">Ketua KOPRI</p>
      </div>
      <?php endif; ?>

    </div>
  </div>
</section>

    <!-- Pricing Section -->
    <!--<section id="pricing" class="pricing section">-->

      <!-- Section Title -->
    <!--  <div class="container section-title" data-aos="fade-up">-->
    <!--    <h2>Pricing</h2>-->
    <!--    <div><span>Check Our</span> <span class="description-title">Pricing</span></div>-->
    <!--  </div><!-- End Section Title -->

    <!--  <div class="container">-->

    <!--    <div class="row gy-4">-->

    <!--      <div class="col-lg-4" data-aos="zoom-in" data-aos-delay="100">-->
    <!--        <div class="pricing-item">-->
    <!--          <h3>Free Plan</h3>-->
    <!--          <p class="description">Ullam mollitia quasi nobis soluta in voluptatum et sint palora dex strater</p>-->
    <!--          <h4><sup>$</sup>0<span> / month</span></h4>-->
    <!--          <a href="#" class="cta-btn">Start a free trial</a>-->
    <!--          <p class="text-center small">No credit card required</p>-->
    <!--          <ul>-->
    <!--            <li><i class="bi bi-check"></i> <span>Quam adipiscing vitae proin</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Nec feugiat nisl pretium</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Nulla at volutpat diam uteera</span></li>-->
    <!--            <li class="na"><i class="bi bi-x"></i> <span>Pharetra massa massa ultricies</span></li>-->
    <!--            <li class="na"><i class="bi bi-x"></i> <span>Massa ultricies mi quis hendrerit</span></li>-->
    <!--            <li class="na"><i class="bi bi-x"></i> <span>Voluptate id voluptas qui sed aperiam rerum</span></li>-->
    <!--            <li class="na"><i class="bi bi-x"></i> <span>Iure nihil dolores recusandae odit voluptatibus</span></li>-->
    <!--          </ul>-->
    <!--        </div>-->
    <!--      </div><!-- End Pricing Item -->

    <!--      <div class="col-lg-4" data-aos="zoom-in" data-aos-delay="200">-->
    <!--        <div class="pricing-item featured">-->
    <!--          <p class="popular">Popular</p>-->
    <!--          <h3>Business Plan</h3>-->
    <!--          <p class="description">Ullam mollitia quasi nobis soluta in voluptatum et sint palora dex strater</p>-->
    <!--          <h4><sup>$</sup>29<span> / month</span></h4>-->
    <!--          <a href="#" class="cta-btn">Start a free trial</a>-->
    <!--          <p class="text-center small">No credit card required</p>-->
    <!--          <ul>-->
    <!--            <li><i class="bi bi-check"></i> <span>Quam adipiscing vitae proin</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Nec feugiat nisl pretium</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Nulla at volutpat diam uteera</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Pharetra massa massa ultricies</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Massa ultricies mi quis hendrerit</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Voluptate id voluptas qui sed aperiam rerum</span></li>-->
    <!--            <li class="na"><i class="bi bi-x"></i> <span>Iure nihil dolores recusandae odit voluptatibus</span></li>-->
    <!--          </ul>-->
    <!--        </div>-->
    <!--      </div><!-- End Pricing Item -->

    <!--      <div class="col-lg-4" data-aos="zoom-in" data-aos-delay="300">-->
    <!--        <div class="pricing-item">-->
    <!--          <h3>Developer Plan</h3>-->
    <!--          <p class="description">Ullam mollitia quasi nobis soluta in voluptatum et sint palora dex strater</p>-->
    <!--          <h4><sup>$</sup>49<span> / month</span></h4>-->
    <!--          <a href="#" class="cta-btn">Start a free trial</a>-->
    <!--          <p class="text-center small">No credit card required</p>-->
    <!--          <ul>-->
    <!--            <li><i class="bi bi-check"></i> <span>Quam adipiscing vitae proin</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Nec feugiat nisl pretium</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Nulla at volutpat diam uteera</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Pharetra massa massa ultricies</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Massa ultricies mi quis hendrerit</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Voluptate id voluptas qui sed aperiam rerum</span></li>-->
    <!--            <li><i class="bi bi-check"></i> <span>Iure nihil dolores recusandae odit voluptatibus</span></li>-->
    <!--          </ul>-->
    <!--        </div>-->
    <!--      </div><!-- End Pricing Item -->

    <!--    </div>-->

    <!--  </div>-->

    <!--</section><!-- /Pricing Section -->

   <!-- Faq Section -->
    <section id="faq" class="faq section light-background">
      <div class="container-fluid">
        <div class="row gy-4">
    
          <div class="col-lg-7 d-flex flex-column justify-content-center order-2 order-lg-1">
    
            <div class="content px-xl-5" data-aos="fade-up" data-aos-delay="100">
              <h3><span>Pertanyaan yang Sering </span><strong>Diajukan</strong></h3>
              <p>
                Berikut beberapa pertanyaan umum seputar kegiatan dan keanggotaan PMII yang sering ditanyakan oleh mahasiswa maupun masyarakat umum.
              </p>
            </div>
    
            <div class="faq-container px-xl-5" data-aos="fade-up" data-aos-delay="200">
    
              <div class="faq-item faq-active">
                <i class="faq-icon bi bi-question-circle"></i>
                <h3>Siapa saja yang bisa bergabung dengan PMII?</h3>
                <div class="faq-content">
                  <p>PMII terbuka bagi seluruh mahasiswa yang berstatus aktif di perguruan tinggi dan memiliki semangat keislaman serta kebangsaan.</p>
                </div>
                <i class="faq-toggle bi bi-chevron-right"></i>
              </div>
    
              <div class="faq-item">
                <i class="faq-icon bi bi-question-circle"></i>
                <h3>Apa itu MAPABA?</h3>
                <div class="faq-content">
                  <p>MAPABA (Masa Penerimaan Anggota Baru) adalah tahap kaderisasi pertama di PMII yang wajib diikuti oleh calon anggota untuk mengenal nilai-nilai dasar organisasi.</p>
                </div>
                <i class="faq-toggle bi bi-chevron-right"></i>
              </div>
    
              <div class="faq-item">
                <i class="faq-icon bi bi-question-circle"></i>
                <h3>Apa manfaat bergabung dengan PMII?</h3>
                <div class="faq-content">
                  <p>Anggota PMII mendapatkan pelatihan kepemimpinan, jaringan organisasi nasional, akses pengembangan diri, serta kesempatan terlibat dalam kegiatan sosial dan advokasi.</p>
                </div>
                <i class="faq-toggle bi bi-chevron-right"></i>
              </div>
    
              <div class="faq-item">
                <i class="faq-icon bi bi-question-circle"></i>
                <h3>Apakah PMII terlibat dalam kegiatan sosial?</h3>
                <div class="faq-content">
                  <p>Ya. PMII aktif dalam kegiatan sosial seperti bakti sosial, advokasi kebijakan publik, bantuan bencana, serta gerakan sosial kemasyarakatan lainnya.</p>
                </div>
                <i class="faq-toggle bi bi-chevron-right"></i>
              </div>
    
              <div class="faq-item">
                <i class="faq-icon bi bi-question-circle"></i>
                <h3>Apakah ada pelatihan rutin setelah MAPABA?</h3>
                <div class="faq-content">
                  <p>Setelah MAPABA, kader dapat mengikuti jenjang kaderisasi selanjutnya seperti PKD (Pelatihan Kader Dasar), PKL, dan pelatihan lainnya sesuai agenda organisasi.</p>
                </div>
                <i class="faq-toggle bi bi-chevron-right"></i>
              </div>
    
              <div class="faq-item">
                <i class="faq-icon bi bi-question-circle"></i>
                <h3>Bagaimana cara mendaftar sebagai anggota PMII?</h3>
                <div class="faq-content">
                  <p>Silakan hubungi pengurus komisariat terdekat atau kunjungi media sosial resmi PMII untuk informasi waktu pelaksanaan MAPABA dan pendaftaran.</p>
                </div>
                <i class="faq-toggle bi bi-chevron-right"></i>
              </div>
    
            </div>
    
          </div>
    
          <div class="col-lg-5 order-1 order-lg-2">
            <img src="assets/img/character_pmii.png" class="img-fluid" alt="FAQ PMII" data-aos="zoom-in" data-aos-delay="100">
          </div>
    
        </div>
      </div>
    </section><!-- /Faq Section -->


  </main>

 <footer id="footer" class="footer dark-background">

  <div class="container footer-top">
    <div class="row gy-4">
      
      <!-- Kolom Kontak -->
      <div class="col-lg-4 col-md-6 footer-about">
      <!-- Gambar Logo di Atas -->
      <div class="mb-3">
        <img src="assets/img/logo.png" alt="Logo PMII Blitar" style="max-width: 200px;">
      </div>
    
      <div class="footer-contact pt-3">
        <p>Jln.Mahbub Junaidi, Sekardangan, Papungan</p>
        <p>Kec. Kanigoro, Kabupaten Blitar, Jawa Timur 66171</p>
        <p class="mt-3"><strong>Whatsapp:</strong> <span>+62 857-0837-5679</span></p>
      </div>
    
      <div class="social-links d-flex mt-4">
        <a href=""><i class="bi bi-whatsapp"></i></a>
        <a href=""><i class="bi bi-twitter-x"></i></a>
        <a href=""><i class="bi bi-facebook"></i></a>
        <a href=""><i class="bi bi-instagram"></i></a>
        <a href=""><i class="bi bi-tiktok"></i></a>
      </div>
    </div>


      <!-- Kolom Maps Lebar -->
      <div class="col-lg-8 col-md-12">
        <h4>Lokasi Kami</h4>
        <div class="map-container" style="width: 100%; height: 300px; overflow: hidden; border-radius: 12px;">
          <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3949.910202965223!2d112.19912217381105!3d-8.110625681146592!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e78ec83aaaaaaa9%3A0x4c718824f7c6a760!2sPendopo%20Islam%20Nusantara!5e0!3m2!1sen!2sid!4v1748905062243!5m2!1sen!2sid"" 
            width="100%" 
            height="100%" 
            style="border:0; border-radius: 12px;" 
            allowfullscreen="" 
            loading="lazy" 
            referrerpolicy="no-referrer-when-downgrade">
          </iframe>
        </div>
      </div>

    </div>
  </div>

  <div class="container copyright text-center mt-4">
    <p>© <span>Copyright</span> <strong class="px-1 sitename">PMII Blitar</strong> <span>All Rights Reserved</span></p>
    <div class="credits">
      Made With ❤️ by Vienna Dev
    </div>
  </div>

</footer>


  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="assets/vendor/purecounter/purecounter_vanilla.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>

</html>